<?php
require($_SERVER['DOCUMENT_ROOT'] . "/configuration/vendor/autoload.php");

use PHPMailer\PHPMailer\PHPMailer;

require_once($_SERVER['DOCUMENT_ROOT'] . "/configuration/config.php");
require_once($_SERVER['DOCUMENT_ROOT'] . "/configuration/Email/smtp.php");

class USER
{
    private $conn;
}

//TITLE NAME
class pageTitle
{
    public $dashboard = 'Dashboard';
    public function getDashboard()
    {
        return $this->dashboard;
    }
}

class emailMessage
{
    public function OtpLoginMsg($full_name,$acct_otp, $APP_NAME, $APP_NUMBER, $APP_EMAIL, $APP_URL, $SITE_ADDRESS)
    {
        return "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8'>
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <title>Verification Code – Crestwood Private Bank</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    table {
      width: 100%;
      border-spacing: 0;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .button {
      background-color: #B22222;
      color: white;
      text-decoration: none;
      padding: 12px 30px;
      border-radius: 4px;
      font-size: 16px;
      display: inline-block;
      text-align: center;
      margin-top: 30px;
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>
          <!-- Header Section -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>$APP_NAME</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body Section -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear $full_name,</p>

            <p>Your login verification code is <strong>$acct_otp</strong>. Please use this code to complete your account sign in.</p>

            <p>If you did not authorize this, please contact support immediately to secure your account:</p>
            <ul>
              <li>📞 24/7 Customer Support: +1 (329) 223-2062, +1 (332) 291-2566</li>
              <li>📧 Support: <a href='mailto:support@crestwoodpb.com'>support@crestwoodpb.com</a></li>
              <li>📧 Security: <a href='mailto:security@crestwoodpb.com'>security@crestwoodpb.com</a></li>
              <li>📧 General Inquiries: <a href='mailto:info@crestwoodpb.com'>info@crestwoodpb.com</a></li>
            </ul>

            <p>Your account security is our priority.</p>

            <p>This is a system-generated email. Please do not reply directly.</p>
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>$APP_NAME</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='#' style='color: #B22222; text-decoration: none;'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2025 Crestwood Private Bank. All rights reserved.</p>
          </div>
        </div>
      </td>
    </tr>
  </table>
</body>
</html>";
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

    public function LoginMsg($full_name, $APP_NAME, $APP_NUMBER, $APP_EMAIL, $APP_URL, $SITE_ADDRESS)
    {
        return "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8'>
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <title>Successful Sign-In Notification â€“ Crestwood Private Bank</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    table {
      width: 100%;
      border-spacing: 0;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>
          <!-- Header Section -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>Crestwood Private Bank</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body Section -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear $full_name,</p>

            <p>You have successfully signed into your $APP_NAME account. If this was you, no further action is required.</p>

            <p>If you did not initiate this sign-in, we strongly recommend:</p>
            <ul>
              <li>Removing the new device from your account.</li>
              <li>Changing your password immediately.</li>
              <li>Contacting our Support Team to ensure your account's security.</li>
            </ul>

            <p>For any inquiries, please contact our Customer Support:</p>
            <ul>
              <li><strong>Support:</strong> <a href='support@crestwoodpb.com' style='color: #B22222; text-decoration: none;'>support@crestwoodpb.com</a></li>
              <li><strong>Security:</strong> <a href='security@crestwoodpb.com' style='color: #B22222; text-decoration: none;'>security@crestwoodpb.com</a></li>
              <li><strong>General Inquiries:</strong> <a href='info@crestwoodpb.com' style='color: #B22222; text-decoration: none;'>info@crestwoodpb.com</a></li>
              <li><strong>Phone:</strong> +1 (329) 223-2062, +1 (332) 291-2566</li>
            </ul>
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>Crestwood Private Bank</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='[Unsubscribe Link]' style='color: #B22222; text-decoration: none;'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2025 $APP_NAME. All rights reserved.</p>
          </div>
        </div>
      </td>
    </tr>
  </table>
</body>
</html>";
    }

    public function DepositMsg($full_name, $amount, $trans_type, $trans_status, $refrence_id, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Transaction Notifications</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #fff;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #fff;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #fff;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #fff;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
<body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>
                        
                <span class='preheader'>Transaction Notifications</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
                                <img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>
                                <img src='https://crestwoodpb.pro/assets/images/logo/hero.png'> 
                                    <h2>Dear $full_name </h2>
                                    <p>Your $trans_type of  $$amount is $trans_status with the refrence id #$refrence_id</p>
                                
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unauthorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }

    public function WithdrawMsg($full_name, $amount, $trans_type, $trans_status, $refrence_id, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Transaction Notifications</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #fff;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #fff;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #fff;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #fff;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
<body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>
                        <div class='logo-head'> 
                <span class='preheader'>Transaction Notifications</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
                                
                                <img src='https://crestwoodpb.pro/assets/images/logo/hero.png'> 
                                    <h2 style='text-transform: capitalize;'>Dear $full_name</h2>
                                    <p>Your $trans_type of $$amount is $trans_status with the refrence id #$refrence_id</p>
                                
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unauthorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }

    public function WireMsg($full_name, $amount, $account_type, $trans_type, $refrence_id, $swift, $routine_number, $bank_country, $bank_name, $trans_status, $account_number, $account_name, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8' />
  <meta name='viewport' content='width=device-width, initial-scale=1.0' />
  <title>Wire Transfer Transaction Notification â€“ Crestwood Private Bank</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    table {
      width: 100%;
      border-spacing: 0;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .transaction-box {
      background-color: #1a1a1a;
      color: #ffffff;
      padding: 20px;
      border-radius: 6px;
      margin-top: 20px;
      font-size: 15px;
      line-height: 1.8;
    }
    .transaction-box strong {
      color: #ffffff;
    }
    a {
      color: #B22222;
      text-decoration: none;
    }
    ul {
      list-style-type: none;
      padding: 0;
    }
    li {
      margin-bottom: 10px;
    }
    @media (max-width: 600px) {
      .email-container {
        width: 100%;
        padding: 15px;
      }
      .transaction-box {
        padding: 15px;
      }
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>

          <!-- Header Section -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>Crestwood Private Bank</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body Section -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear <strong>[Full Name]</strong>,</p>
            <p>We wish to inform you that a wire transfer has been successfully processed on your account. Below are the transaction details:</p>

            <div class='transaction-box'>
              <p><strong>Account Number:</strong> $formatted_account</p>
              <p><strong>Account Name:</strong> $full_name</p>
              <p><strong>Amount:</strong> USD$formatted_amount</p>
              <p><strong>Transaction Type:</strong> $trans_type</p>
              <p><strong>Current Balance:</strong> USD$formatted_balance</p>
              <p><strong>Transaction Status:</strong> $trans_status</p>
            </div>

            <p>To view your full account statement or manage your account, log in at: <a href='https://crestwoodpb.com'>https://crestwoodpb.com</a></p>

            <p>If you did not authorize this transaction, please contact us immediately at our Customer Support:</p>

            <ul>
              <li><strong>Support:</strong> <a href='mailto:support@crestwoodpb.com'>support@crestwoodpb.com</a></li>
              <li><strong>Security:</strong> <a href='mailto:security@crestwoodpb.com'>security@crestwoodpb.com</a></li>
              <li><strong>General Inquiries:</strong> <a href='mailto:info@crestwoodpb.com'>info@crestwoodpb.com</a></li>
              <li><strong>Phone:</strong> +1 (329) 223-2062, +1 (332) 291-2566</li>
            </ul>
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>$APP_NAME</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='#'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2025 Crestwood Private Bank. All rights reserved.</p>
          </div>

        </div>
      </td>
    </tr>
  </table>
</body>
</html>";
    }

    public function RegisterMsg($full_name, $internetid, $acct_status, $APP_NAME, $APP_URL, $SITE_ADDRESS,$acct_password,$acct_pin)
    {
        return "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8'>
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <title>Welcome to $APP_NAME</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    table {
      width: 100%;
      border-spacing: 0;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .button {
      background-color: #B22222;
      color: white;
      text-decoration: none;
      padding: 12px 30px;
      border-radius: 4px;
      font-size: 16px;
      display: inline-block;
      text-align: center;
      margin-top: 30px;
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>
          <!-- Header Section -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>$APP_NAME</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body Section -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear $full_name,</p>
            <p>Thank you for opening an account with <strong>Crestwood Private Bank</strong>. We are pleased to welcome you and look forward to providing you with exceptional banking services tailored to your financial needs.</p>

            <p><strong>Your Account Details:</strong></p>
            <ul>
              <li><strong>Account Number:</strong> $internetid</li>
              <li><strong>Login URL:</strong> <a href='https://crestwoodpb.pro/login.php'>https://crestwoodpb.pro/login.php</a></li>
              <li><strong>Account Status:</strong> $acct_status</li>
               <a href='https://crestwoodpb.pro/login.php' class='button'>Login to your account</a>
               
            </ul>

            <p>Please change your password and PIN upon successful account activation and first login via the secure client portal.</p>

            <p>If you require any assistance, our support team is available 24/7.</p>

            <p><strong>Contact Us:</strong></p>
            <ul>
              <li>Support: <a href='mailto:support@crestwoodpb.com'>support@crestwoodpb.com</a></li>
              <li>Security: <a href='mailto:security@crestwoodpb.com'>security@crestwoodpb.com</a></li>
              <li>General Inquiries: <a href='mailto:info@crestwoodpb.com'>info@crestwoodpb.com</a></li>
              <li>Phone: +1 (329) 223-2062, +1 (332) 291-2566</li>
            </ul>

            <p>We appreciate your trust in Crestwood Private Bank and look forward to serving you.</p>

          
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>Crestwood Private Bank</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='[Unsubscribe Link]' style='color: #B22222; text-decoration: none;'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2025 Crestwood Private Bank. All rights reserved.</p>
          </div>
        </div>
      </td>
    </tr>
  </table>
</body>
</html>";
    }
    
    
    public function RegisterVerificationMsg($firstname, $verification_token, $APP_NAME, $APP_URL)
{
    $verification_url = $APP_URL . "/verify.php?token=" . $verification_token;
    return "
    
    
    <!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8'>
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <title>Email Verification â€“ Crestwood Private Bank</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    table {
      width: 100%;
      border-spacing: 0;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .button {
      background-color: #B22222;
      color: white;
      text-decoration: none;
      padding: 12px 30px;
      border-radius: 4px;
      font-size: 16px;
      display: inline-block;
      text-align: center;
      margin-top: 30px;
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>
          <!-- Header Section -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>Crestwood Private Bank</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body Section -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear $firstname $lasttname,</p>
            <p>Thank you for choosing <strong>$APP_NAME!</strong>. We appreciate your trust in our services.</p>
            <p>To complete your registration, please verify your email address by clicking the link below:</p>
            <div style='text-align: center;'>
              <a href='$verification_url' class='button'>Verify My Email</a>
            </div>
            <p>Once your email is successfully verified, you will receive a welcome email containing your account login details and credentials.</p>
            <p>If you require any assistance, please do not hesitate to contact us:</p>
            <ul>
              <li>Support: <a href='support@crestwoodpb.com'>support@crestwoodpb.com</a></li>
              <li>Security: <a href='security@crestwoodpb.com'>security@crestwoodpb.com</a></li>
              <li>General Inquiries: <a href='info@crestwoodpb.com'>info@crestwoodpb.com</a></li>
              <li>Phone: +1 (329) 223-2062, +1 (332) 291-2566</li>
            </ul>
            <p>This is a system-generated email. Please do not reply directly.</p>
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>$APP_NAME</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='#' style='color: #B22222; text-decoration: none;'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2025 $APP_NAME. All rights reserved.</p>
          </div>
        </div>
      </td>
    </tr>
  </table>
</body>
</html>
    ";
}

    
    public function RegisterAdminMsg($full_name, $internetid, $acct_status, $APP_NAME, $APP_URL, $SITE_ADDRESS,$acct_password,$acct_pin)
    {
        return "<!doctype html>
        <html>
                <head>
                    <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                    <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                    <title>New User Registeration</title>
                    <style>
                    /* -------------------------------------
                        GLOBAL RESETS
                    ------------------------------------- */
                    
                    /*All the styling goes here*/
                    
                    img {
                        border: none;
                        -ms-interpolation-mode: bicubic;
                        max-width: 100%; 
                    }
                
                    body {
                        background-color: #fff;
                        font-family: sans-serif;
                        -webkit-font-smoothing: antialiased;
                        font-size: 14px;
                        line-height: 1.4;
                        margin: 0;
                        padding: 0;
                        -ms-text-size-adjust: 100%;
                        -webkit-text-size-adjust: 100%; 
                    }
                
                    table {
                        border-collapse: separate;
                        mso-table-lspace: 0pt;
                        mso-table-rspace: 0pt;
                        width: 100%; }
                        table td {
                        font-family: sans-serif;
                        font-size: 14px;
                        vertical-align: top; 
                    }
                
                    /* -------------------------------------
                        BODY & CONTAINER
                    ------------------------------------- */
                
                    .body {
                        background-color: #fff;
                        width: 100%; 
                    }
                
                    /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                    .container {
                        display: block;
                        margin: 0 auto !important;
                        /* makes it centered */
                        max-width: 580px;
                        padding: 10px;
                        width: 580px; 
                    }
                
                    /* This should also be a block element, so that it will fill 100% of the .container */
                    .content {
                        box-sizing: border-box;
                        display: block;
                        margin: 0 auto;
                        max-width: 580px;
                        padding: 10px; 
                    }
                
                    /* -------------------------------------
                        HEADER, FOOTER, MAIN
                    ------------------------------------- */
                    .main {
                        background: #ffffff;
                        border-radius: 3px;
                        width: 100%; 
                    }
                
                    .wrapper {
                        box-sizing: border-box;
                        padding: 20px; 
                    }
                
                    .content-block {
                        padding-bottom: 10px;
                        padding-top: 10px;
                    }
                
                    .footer {
                        clear: both;
                        margin-top: 10px;
                        text-align: center;
                        width: 100%; 
                    }
                        .footer td,
                        .footer p,
                        .footer span,
                        .footer a {
                        color: #fff;
                        font-size: 12px;
                        text-align: center; 
                    }
                
                    /* -------------------------------------
                        TYPOGRAPHY
                    ------------------------------------- */
                    h1,
                    h2,
                    h3,
                    h4 {
                        color: #000000;
                        font-family: sans-serif;
                        font-weight: 400;
                        line-height: 1.4;
                        margin: 0;
                        margin-bottom: 30px; 
                    }
                
                    h1 {
                        font-size: 35px;
                        font-weight: 300;
                        text-align: center;
                        text-transform: capitalize; 
                    }
                
                    p,
                    ul,
                    ol {
                        font-family: sans-serif;
                        font-size: 14px;
                        font-weight: normal;
                        margin: 0;
                        margin-bottom: 15px; 
                    }
                        p li,
                        ul li,
                        ol li {
                        list-style-position: inside;
                        margin-left: 5px; 
                    }
                
                    a {
                        color: #3498db;
                        text-decoration: underline; 
                    }
                
                    /* -------------------------------------
                        BUTTONS
                    ------------------------------------- */
                    .btn {
                        box-sizing: border-box;
                        width: 100%; }
                        .btn > tbody > tr > td {
                        padding-bottom: 15px; }
                        .btn table {
                        width: auto; 
                    }
                        .btn table td {
                        background-color: #ffffff;
                        border-radius: 5px;
                        text-align: center; 
                    }
                        .btn a {
                        background-color: #ffffff;
                        border: solid 1px #3498db;
                        border-radius: 5px;
                        box-sizing: border-box;
                        color: #3498db;
                        cursor: pointer;
                        display: inline-block;
                        font-size: 14px;
                        font-weight: bold;
                        margin: 0;
                        padding: 12px 25px;
                        text-decoration: none;
                        text-transform: capitalize; 
                    }
                
                    .btn-primary table td {
                        background-color: #3498db; 
                    }
                
                    .btn-primary a {
                        background-color: #3498db;
                        border-color: #3498db;
                        color: #ffffff; 
                    }
                
                    /* -------------------------------------
                        OTHER STYLES THAT MIGHT BE USEFUL
                    ------------------------------------- */
                    .last {
                        margin-bottom: 0; 
                    }
                
                    .first {
                        margin-top: 0; 
                    }
                
                    .align-center {
                        text-align: center; 
                    }
                
                    .align-right {
                        text-align: right; 
                    }
                
                    .align-left {
                        text-align: left; 
                    }
                
                    .clear {
                        clear: both; 
                    }
                
                    .mt0 {
                        margin-top: 0; 
                    }
                
                    .mb0 {
                        margin-bottom: 0; 
                    }
                
                    .preheader {
                        color: transparent;
                        display: none;
                        height: 0;
                        max-height: 0;
                        max-width: 0;
                        opacity: 0;
                        overflow: hidden;
                        mso-hide: all;
                        visibility: hidden;
                        width: 0; 
                    }
                
                    .powered-by a {
                        text-decoration: none; 
                    }
                
                    hr {
                        border: 0;
                        border-bottom: 1px solid #fff;
                        margin: 20px 0; 
                    }
                
                    /* -------------------------------------
                        RESPONSIVE AND MOBILE FRIENDLY STYLES
                    ------------------------------------- */
                    @media only screen and (max-width: 620px) {
                        table.body h1 {
                        font-size: 28px !important;
                        margin-bottom: 10px !important; 
                        }
                        table.body p,
                        table.body ul,
                        table.body ol,
                        table.body td,
                        table.body span,
                        table.body a {
                        font-size: 16px !important; 
                        }
                        table.body .wrapper,
                        table.body .article {
                        padding: 10px !important; 
                        }
                        table.body .content {
                        padding: 0 !important; 
                        }
                        table.body .container {
                        padding: 0 !important;
                        width: 100% !important; 
                        }
                        table.body .main {
                        border-left-width: 0 !important;
                        border-radius: 0 !important;
                        border-right-width: 0 !important; 
                        }
                        table.body .btn table {
                        width: 100% !important; 
                        }
                        table.body .btn a {
                        width: 100% !important; 
                        }
                        table.body .img-responsive {
                        height: auto !important;
                        max-width: 100% !important;
                        width: auto !important; 
                        }
                    }
                
                    /* -------------------------------------
                        PRESERVE THESE STYLES IN THE HEAD
                    ------------------------------------- */
                    @media all {
                        .ExternalClass {
                        width: 100%; 
                        }
                        .ExternalClass,
                        .ExternalClass p,
                        .ExternalClass span,
                        .ExternalClass font,
                        .ExternalClass td,
                        .ExternalClass div {
                        line-height: 100%; 
                        }
                        .apple-link a {
                        color: inherit !important;
                        font-family: inherit !important;
                        font-size: inherit !important;
                        font-weight: inherit !important;
                        line-height: inherit !important;
                        text-decoration: none !important; 
                        }
                        #MessageViewBody a {
                        color: inherit;
                        text-decoration: none;
                        font-size: inherit;
                        font-family: inherit;
                        font-weight: inherit;
                        line-height: inherit;
                        }
                        .btn-primary table td:hover {
                        background-color: #34495e !important; 
                        }
                        .btn-primary a:hover {
                        background-color: #34495e !important;
                        border-color: #34495e !important; 
                        } 
                    }
                
                    </style>
                </head>
                <body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>

                    <span class='preheader'>New User Registeration Email Notification</span>
                    <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                    <tr>
                        <td>&nbsp;</td>
                        <td class='container'>
                        <div class='content'>
                
                            <table role='presentation' class='main'>
                
                            <tr>
                                <td class='wrapper'>
                                <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                    <tr>
                                    <td>
                                    <img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>
                                    <img src='https://crestwoodpb.pro/assets/images/logo/hero.png'> 
                                    <h2>Dear admin,</h2>
                                    <p><strong>Welcome to $APP_NAME</strong>
                                    <br><br>A new user has successfully  Registered at $APP_NAME.<br>
                                     <br>
                                    
                                    <strong>Below are the Account Details</strong><br>
                                    Account Number: <strong>$internetid</strong><br>
                                    
                                    Account Password: $acct_password<br>
                                    Account Pin: $acct_pin<br>
                                    Account Status: $acct_status<br>
                                    
                                    <br>
                                    <a style='background-color:red; color:#fff; padding:13px; border: solid 1px; border-radius:6px;' href='https://crestwoodpb.pro/admin/login.php'>Login To Admin</a>
                                    
                                    
                                    </p>
                                                         
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unauthorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
        
                        </td>
                    </tr>
                    </table>
                </body>
        </html>";
    }

    public function ForgotMsg($full_name, $email, $reset_token, $internetid, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8' />
  <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
  <title>Password Reset Request  Crestwood Private Bank</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .button {
      background-color: #B22222;
      color: white;
      text-decoration: none;
      padding: 12px 30px;
      border-radius: 4px;
      font-size: 16px;
      display: inline-block;
      text-align: center;
      margin-top: 25px;
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>

          <!-- Crestwood Header -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>Crestwood Private Bank</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear $full_name,</p>

            <p>We received a password reset request for your Crestwood Private Bank account associated with account number <strong>$internetid</strong>.</p>

            <p>If you initiated this request, please click the button below to reset your password:</p>

            <div style='text-align: center;'>
              <a href='$APP_URL/updatePassword.php?email=$email&reset_token=$reset_token' class='button'>Reset Password</a>
            </div>

            <p>If the button above is not clickable, please copy and paste the following URL into your browser:</p>
            <p style='word-break: break-word; color: #B22222;'>
             $APP_URL/updatePassword.php?email=$email&reset_token=$reset_token
            </p>

            <p>If you did not request this password reset, kindly disregard this email. Your account remains secure and no changes have been made.</p>

            <p>If you require any assistance, please feel free to contact us:</p>
            <ul>
              <li>General Inquiries: <a href='mailto:support@crestwoodpb.com'>support@crestwoodpb.com</a></li>
              <li>Security Concerns: <a href='mailto:security@crestwoodpb.com'>security@crestwoodpb.com</a></li>
              <li>Phone: +1 (329) 223-2062, +1 (332) 291-2566</li>
            </ul>

            <p>Thank you for trusting Crestwood Private Bank. Your account security is our top priority.</p>
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>Crestwood Private Bank</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='[Unsubscribe Link]' style='color: #B22222; text-decoration: none;'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2024 Crestwood Private Bank. All rights reserved.</p>
          </div>

        </div>
      </td>
    </tr>
  </table>
</body>
</html>";
    }

    public function DomMsg($full_name, $amount, $account_number, $account_name, $account_type, $bank_country, $trans_type, $refrence_id, $trans_status, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Domestic Transfer Notifications</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #fff;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #fff;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #fff;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #fff;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
  <body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>

                <span class='preheader'>Domestic Transfer Notifications</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
<img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>
                                    <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' style='display: block;   margin: auto;   width: 50%;'>
                                    <h2 style='text-transform: capitalize;'>Dear $full_name,</h2>
                                    <p>Your $trans_type of <strong>$amount</strong> to  $account_number, $account_name, $account_type, $bank_country with the refrence id #$refrence_id is $trans_status.</p>
                                
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unauthorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }

    public function pinRequest($full_name, $acct_otp, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>One-time Code Notifications</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #fff;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #fff;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #fff;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #fff;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
  <body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>

                <span class='preheader'>One-time Code Notifications</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
                                <img src='https://crestwoodpb.pro/assets/images/logo/hero.png'> 
                                    <h2 style='text-transform: capitalize;'>Dear $full_name,</h2>
                                    <p>Kindly use <strong>$acct_otp</strong> to validate your One-Time Code.</p>
                                                        
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unauthorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }

    public function InterMsg($full_name, $amount, $account_number, $account_name, $refrence_id, $trans_type, $trans_status, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Self transfer Notifications</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #fff;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #fff;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #fff;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #fff;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
          <body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>

                <span class='preheader'>Self transfer Notifications</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
                               <img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>
                                    <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' style='display: block;   margin: auto;   width: 50%;'>
                                <h2 style='text-transform: capitalize;'>Dear $full_name,</h2>
                                <p>Your $trans_type of <strong>$amount</strong> to  $account_number, $account_name with the refrence id #$refrence_id is $trans_status.</p>
                                                      
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unauthorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }

    public function StockMsg($full_name, $amount, $account_name, $APP_NAME, $trans_type, $trans_status, $refrence_id, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Stock Purchase Notifications</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #fff;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #fff;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #fff;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #fff;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
             <body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>

                <span class='preheader'>Stock Purchase Transaction</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
<img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>
                                    <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' style='display: block;   margin: auto;   width: 50%;'>
                                    <h2 style='text-transform: capitalize;'>Dear $full_name</h2>
                                    <p>Your $trans_type of <strong>$account_name - $$amount</strong> is $trans_status with theb refrence id #$refrence_id</p>
                                
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unauthorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }

    public function LoanMsg($full_name, $amount, $trans_type, $trans_status, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Loan Request Notification</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #fff;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #fff;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #fff;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #fff;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
             <body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>

                <span class='preheader'>Loan Request Notifications</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
<img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>
                                    <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' style='display: block;   margin: auto;   width: 50%;'>
                                    <h2 style='text-transform: capitalize;'>Dear $full_name</h2>
                                    <p>Your $trans_type Request with the amount $$amount on your account  is $trans_status.</p>
                                
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unauthorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }

    public function PasswordMsg($full_name, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8' />
  <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
  <title>Password Changed  Crestwood Private Bank</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>

          <!-- Crestwood Header -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>Crestwood Private Bank</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear $full_name,</p>

            <p>We are writing to confirm that your Crestwood Private Bank account password has been successfully changed.</p>

            <p>If you made this change, no further action is needed.</p>

            <p>If you did not initiate this change, please contact our Security Team immediately to review your account activity and restore access.</p>

            <p>If you require any assistance, please feel free to contact us:</p>
            <ul>
              <li>General Inquiries: <a href='support@crestwoodpb.com'>support@crestwoodpb.com</a></li>
              <li>Security Concerns: <a href='security@crestwoodpb.com'>security@crestwoodpb.com</a></li>
              <li>Phone: +1 (332) 291-2020</li>
            </ul>

            <p>Thank you for banking with Crestwood Private Bank.</p>

            <p style='margin-top: 40px; font-size: 14px; color: #999;'><em>This is a system-generated email. Please do not reply to this message.</em></p>
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>Crestwood Private Bank</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='[Unsubscribe Link]' style='color: #B22222; text-decoration: none;'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2025 Crestwood Private Bank. All rights reserved.</p>
          </div>

        </div>
      </td>
    </tr>
  </table>
</body>
</html>";
    }

    public function PinMsg($full_name, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "
        
        
        
        <!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8' />
  <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
  <title>PIN Code Changed  Crestwood Private Bank</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>

          <!-- Header Section -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>Crestwood Private Bank</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear $full_name,</p>

            <p>This is a confirmation that your PIN code associated with your Crestwood Private Bank account has been successfully changed.</p>

            <p>If you made this change, no further action is required.</p>

            <p>If you did not authorize this PIN change, please contact our Security Team immediately so we can take steps to protect your account.</p>

            <p>If you require assistance, please contact us at:</p>
            <ul>
              <li>General Inquiries: <a href='mailto:support@crestwoodpb.com'>support@crestwoodpb.com</a></li>
              <li>Security Concerns: <a href='mailto:security@crestwoodpb.com'>security@crestwoodpb.com</a></li>
              <li>Phone: +1 (332) 291-2020</li>
            </ul>

            <p>Thank you for banking securely with Crestwood Private Bank.</p>

            <p style='margin-top: 40px; font-size: 14px; color: #999;'><em>This is a system-generated email. Please do not reply to this message.</em></p>
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>Crestwood Private Bank</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='[Unsubscribe Link]' style='color: #B22222; text-decoration: none;'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2025 Crestwood Private Bank. All rights reserved.</p>
          </div>

        </div>
      </td>
    </tr>
  </table>
</body>
</html>
        
        
        ";
    }

    public function CardMsg($full_name, $card_name, $amount, $card_status, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Card Request Notifications</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #fff;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #fff;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #fff;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #fff;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
  <body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>

                <span class='preheader'>Card Notifications</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
<img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>
                                    <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' style='display: block;   margin: auto;   width: 50%;'>
                                    <h2 style='text-transform: capitalize;'>Dear $full_name,</h2>
                                    <p>You have been charged with a fee of $$amount for $card_name on account:   request and it is $card_status.</p>
                                
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unauthorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }

    public function TicketMsg($full_name, $ticket_message, $ticket_status, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Ticket Notifications</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #fff;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #fff;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #fff;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #fff;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
  <body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>

                <span class='preheader'>Ticket Notifications</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                         <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
<img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>
                                    <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' style='display: block;   margin: auto;   width: 50%;'>
                                    <h2 style='text-transform: capitalize;'>Dear $full_name,</h2>
                                    <p>Your Ticket Status on Account:  is $ticket_status and been reviewed.<br><br><br>
                                    Message: <strong>$ticket_message</strong>
                                    </p>
                                                          
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unauthorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }
}
