<?php
require_once($_SERVER['DOCUMENT_ROOT'] . "/configuration/vendor/autoload.php");

use PHPMailer\PHPMailer\PHPMailer;

require_once($_SERVER['DOCUMENT_ROOT'] . "/configuration/Email/smtp.php");

class emailMessage
{

 public function RegisterMsg($full_name, $internetid, $acct_status, $APP_NAME, $APP_URL, $SITE_ADDRESS,$acct_password,$acct_pin)
    {
        // Format account number
    $last_six = substr($internetid, -6);
    $mask_length = max(0, strlen($internetid) - 6); // Avoid negative length
    $masked = str_repeat("*", $mask_length);
    $formatted_account = $masked . $last_six;
    
        return "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8'>
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <title>$APP_NAME</title>
  <style>
    body {
      font-family: 'Segoe UI', Arial, sans-serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .header {
      background: linear-gradient(to right, #6A4E3A, #B22222);
      text-align: center;
      padding: 30px 0;
    }
    .header p {
      color: white;
      font-family: 'Segoe UI', sans-serif;
      margin: 0;
    }
    .header .subtitle {
      font-size: 18px;
      color: white;
      margin-top: 10px;
    }
    .footer {
      background-color: #f9f9f9;
      text-align: center;
      padding: 25px 0;
      font-size: 12px;
      color: #888;
    }
    .button {
      background-color: #B22222;
      color: white;
      text-decoration: none;
      padding: 12px 30px;
      border-radius: 4px;
      font-size: 16px;
      display: inline-block;
      text-align: center;
      margin-top: 30px;
    }
  </style>
</head>
<body>

  <div class='email-container'>

    <!-- Header Section -->
    <div class='header'>
      <p style='font-size: 36px; font-weight: bold;'>$APP_NAME</p>
      <p class='subtitle'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
    </div>

    <!-- Email Body Section -->
    <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
      <p>Dear $full_name,</p>
      <p>Thank you for opening an account with Crestwood Private Bank. We are pleased to welcome you as a valued customer and are excited to serve your banking needs.</p>

      <p><strong>Below are your account details:</strong></p>
      <ul>
        <li><strong>Account Number:</strong> $internetid</li>
        <li><strong>Account Status:</strong> Active</li>
        <li><strong>Account Login URL:</strong> 
        <br><a href='https://crestwoodpb.pro/login.php' class='button'>Login to your account</a></li>
      </ul>

      <p><strong>For your security, please do not share your account password or PIN with anyone. Below are your login credentials:</strong></p>
      <ul>
        <li><strong>Account Password:</strong> $acct_password</li>
        <li><strong>Account PIN:</strong> $acct_pin</li>
      </ul>

      <p><strong>Please change your password and PIN upon successful account activation and first login via the secure client portal.</strong></p>

      <p>If you require any assistance or have questions regarding your account, our dedicated support team is here to help. Please do not hesitate to contact us for any concerns:</p>
      <ul>
        <li><strong>General:</strong> <a href='support@crestwoodpb.com'>Support@crestwoodpb.com</a></li>
        <li><strong>Security:</strong> <a href='security@crestwoodpb.com'>Security@crestwoodpb.com</a></li>
              <li><strong>General Inquiries: <a href='info@crestwoodpb.com'>info@crestwoodpb.com</a></li>
        <li><strong>Phone:</strong> +1 (329) 223-2062, +1 (332) 291-2566</li>
      </ul>

      <p>Please be assured that your account security is our top priority. If you experience any issues or suspect any unauthorized activity, contact us immediately.</p>

      <p>Thank you again for choosing $APP_NAME. We look forward to supporting your financial journey.</p>
    </div>

    <!-- Footer Section -->
    <div class='footer'>
      <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
      <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
      <p style='margin: 10px 0;'><strong>$APP_NAME</strong><br>1441 Broadway, New York, NY 10018</p>
      <p style='margin: 10px 0;'><a href='#' style='color: #B22222; text-decoration: none;'>Click here to unsubscribe</a></p>
      <p style='margin: 10px 0;'>&copy; 2025 $APP_NAME. All rights reserved.</p>
    </div>
  </div>

</body>
</html>";
    }

    public function AdminFundingMsg($full_name, $amount, $user_balance, $internetid, $trans_status, $trans_type, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        // Format account number
    $last_six = substr($internetid, -6);
    $mask_length = max(0, strlen($internetid) - 6); // Avoid negative length
    $masked = str_repeat("*", $mask_length);
    $formatted_account = $masked . $last_six;
    
    // Format amounts
    if ($trans_type  == "Credit") {
        $user_balance_sum =$user_balance + $amount;
    }else{
        $user_balance_sum =$user_balance - $amount;
    }
    
    $formatted_amount = number_format($amount, 2);
    $formatted_balance = number_format($user_balance_sum, 2);
    
        return "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8'>
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <title>$trans_type Transaction Notification – $APP_NAME</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    table {
      width: 100%;
      border-spacing: 0;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .transaction-box {
      background-color: #1a1a1a;
      color: #ffffff;
      padding: 20px;
      border-radius: 6px;
      margin-top: 20px;
      font-size: 15px;
      line-height: 1.8;
    }
    .transaction-box strong {
      color: #ffffff;
    }
    a {
      color: #B22222;
      text-decoration: none;
    }
    ul {
      list-style-type: none;
      padding: 0;
    }
    li {
      margin-bottom: 10px;
    }
    @media (max-width: 600px) {
      .email-container {
        width: 100%;
        padding: 15px;
      }
      .transaction-box {
        padding: 15px;
      }
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>

          <!-- Header Section -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>$APP_NAME</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body Section -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear $full_name,</p>

            <p>We wish to inform you that a $trans_type transaction has been successfully processed on your account. Please find the transaction details below:</p>

            <div class='transaction-box'>
              <p><strong>Account Number:</strong> $formatted_account</p>
              <p><strong>Account Name:</strong> $full_name</p>
              <p><strong>Amount:</strong> USD$formatted_amount</p>
              <p><strong>Transaction Type:</strong> $trans_type Transaction</p>
              <p><strong>Current Balance:</strong> USD$formatted_balance</p>
              <p><strong>Transaction Status:</strong> Completed</p>
            </div>

            <p>No further action is required on your part. For any inquiries, please contact our Customer support:</p>

            <ul>
              <li><strong>Support:</strong> <a href='mailto:support@crestwoodpb.com' style='color: #B22222; text-decoration: none;'>support@crestwoodpb.com</a></li>
              <li><strong>Security:</strong> <a href='mailto:security@crestwoodpb.com' style='color: #B22222; text-decoration: none;'>security@crestwoodpb.com</a></li>
              <li><strong>General Inquiries:</strong> <a href='mailto:info@crestwoodpb.com' style='color: #B22222; text-decoration: none;'>info@crestwoodpb.com</a></li>
              <li><strong>Phone:</strong> +1 (329) 223-2062, +1 (332) 291-2566</li>
            </ul>
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>$APP_NAME</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='[Unsubscribe Link]' style='color: #B22222; text-decoration: none;'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2025 $APP_NAMEk. All rights reserved.</p>
          </div>

        </div>
      </td>
    </tr>
  </table>
</body>
</html>";
    }






















    public function AdminTicketMsg($full_name, $messagereply, $internetid, $trans_status, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
<html>
        <head>
            <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
            <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
            <title>Ticket Notifications</title>
            <style>
            /* -------------------------------------
                GLOBAL RESETS
            ------------------------------------- */
            
            /*All the styling goes here*/
            
            img {
                border: none;
                -ms-interpolation-mode: bicubic;
                max-width: 100%; 
            }
        
            body {
                background-color: #f6f6f6;
                font-family: sans-serif;
                -webkit-font-smoothing: antialiased;
                font-size: 14px;
                line-height: 1.4;
                margin: 0;
                padding: 0;
                -ms-text-size-adjust: 100%;
                -webkit-text-size-adjust: 100%; 
            }
        
            table {
                border-collapse: separate;
                mso-table-lspace: 0pt;
                mso-table-rspace: 0pt;
                width: 100%; }
                table td {
                font-family: sans-serif;
                font-size: 14px;
                vertical-align: top; 
            }
        
            /* -------------------------------------
                BODY & CONTAINER
            ------------------------------------- */
        
            .body {
                background-color: #f6f6f6;
                width: 100%; 
            }
        
            /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
            .container {
                display: block;
                margin: 0 auto !important;
                /* makes it centered */
                max-width: 580px;
                padding: 10px;
                width: 580px; 
            }
        
            /* This should also be a block element, so that it will fill 100% of the .container */
            .content {
                box-sizing: border-box;
                display: block;
                margin: 0 auto;
                max-width: 580px;
                padding: 10px; 
            }
        
            /* -------------------------------------
                HEADER, FOOTER, MAIN
            ------------------------------------- */
            .main {
                background: #ffffff;
                border-radius: 3px;
                width: 100%; 
            }
        
            .wrapper {
                box-sizing: border-box;
                padding: 20px; 
            }
        
            .content-block {
                padding-bottom: 10px;
                padding-top: 10px;
            }
        
            .footer {
                clear: both;
                margin-top: 10px;
                text-align: center;
                width: 100%; 
            }
                .footer td,
                .footer p,
                .footer span,
                .footer a {
                color: #999999;
                font-size: 12px;
                text-align: center; 
            }
        
            /* -------------------------------------
                TYPOGRAPHY
            ------------------------------------- */
            h1,
            h2,
            h3,
            h4 {
                color: #000000;
                font-family: sans-serif;
                font-weight: 400;
                line-height: 1.4;
                margin: 0;
                margin-bottom: 30px; 
            }
        
            h1 {
                font-size: 35px;
                font-weight: 300;
                text-align: center;
                text-transform: capitalize; 
            }
        
            p,
            ul,
            ol {
                font-family: sans-serif;
                font-size: 14px;
                font-weight: normal;
                margin: 0;
                margin-bottom: 15px; 
            }
                p li,
                ul li,
                ol li {
                list-style-position: inside;
                margin-left: 5px; 
            }
        
            a {
                color: #3498db;
                text-decoration: underline; 
            }
        
            /* -------------------------------------
                BUTTONS
            ------------------------------------- */
            .btn {
                box-sizing: border-box;
                width: 100%; }
                .btn > tbody > tr > td {
                padding-bottom: 15px; }
                .btn table {
                width: auto; 
            }
                .btn table td {
                background-color: #ffffff;
                border-radius: 5px;
                text-align: center; 
            }
                .btn a {
                background-color: #ffffff;
                border: solid 1px #3498db;
                border-radius: 5px;
                box-sizing: border-box;
                color: #3498db;
                cursor: pointer;
                display: inline-block;
                font-size: 14px;
                font-weight: bold;
                margin: 0;
                padding: 12px 25px;
                text-decoration: none;
                text-transform: capitalize; 
            }
        
            .btn-primary table td {
                background-color: #3498db; 
            }
        
            .btn-primary a {
                background-color: #3498db;
                border-color: #3498db;
                color: #ffffff; 
            }
        
            /* -------------------------------------
                OTHER STYLES THAT MIGHT BE USEFUL
            ------------------------------------- */
            .last {
                margin-bottom: 0; 
            }
        
            .first {
                margin-top: 0; 
            }
        
            .align-center {
                text-align: center; 
            }
        
            .align-right {
                text-align: right; 
            }
        
            .align-left {
                text-align: left; 
            }
        
            .clear {
                clear: both; 
            }
        
            .mt0 {
                margin-top: 0; 
            }
        
            .mb0 {
                margin-bottom: 0; 
            }
        
            .preheader {
                color: transparent;
                display: none;
                height: 0;
                max-height: 0;
                max-width: 0;
                opacity: 0;
                overflow: hidden;
                mso-hide: all;
                visibility: hidden;
                width: 0; 
            }
        
            .powered-by a {
                text-decoration: none; 
            }
        
            hr {
                border: 0;
                border-bottom: 1px solid #f6f6f6;
                margin: 20px 0; 
            }
        
            /* -------------------------------------
                RESPONSIVE AND MOBILE FRIENDLY STYLES
            ------------------------------------- */
            @media only screen and (max-width: 620px) {
                table.body h1 {
                font-size: 28px !important;
                margin-bottom: 10px !important; 
                }
                table.body p,
                table.body ul,
                table.body ol,
                table.body td,
                table.body span,
                table.body a {
                font-size: 16px !important; 
                }
                table.body .wrapper,
                table.body .article {
                padding: 10px !important; 
                }
                table.body .content {
                padding: 0 !important; 
                }
                table.body .container {
                padding: 0 !important;
                width: 100% !important; 
                }
                table.body .main {
                border-left-width: 0 !important;
                border-radius: 0 !important;
                border-right-width: 0 !important; 
                }
                table.body .btn table {
                width: 100% !important; 
                }
                table.body .btn a {
                width: 100% !important; 
                }
                table.body .img-responsive {
                height: auto !important;
                max-width: 100% !important;
                width: auto !important; 
                }
            }
        
            /* -------------------------------------
                PRESERVE THESE STYLES IN THE HEAD
            ------------------------------------- */
            @media all {
                .ExternalClass {
                width: 100%; 
                }
                .ExternalClass,
                .ExternalClass p,
                .ExternalClass span,
                .ExternalClass font,
                .ExternalClass td,
                .ExternalClass div {
                line-height: 100%; 
                }
                .apple-link a {
                color: inherit !important;
                font-family: inherit !important;
                font-size: inherit !important;
                font-weight: inherit !important;
                line-height: inherit !important;
                text-decoration: none !important; 
                }
                #MessageViewBody a {
                color: inherit;
                text-decoration: none;
                font-size: inherit;
                font-family: inherit;
                font-weight: inherit;
                line-height: inherit;
                }
                .btn-primary table td:hover {
                background-color: #34495e !important; 
                }
                .btn-primary a:hover {
                background-color: #34495e !important;
                border-color: #34495e !important; 
                } 
            }
        
            </style>
        </head>
<body style='background: #fff; border: none #111; padding: 10px; border-radius: 20px;'>
                        <img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>                                 <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' display: block;   margin: auto;   width: 50%;'>
            <span class='preheader'>Ticket Notifications</span>
            <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
            <tr>
                <td>&nbsp;</td>
                <td class='container'>
                <div class='content'>
        
                    <table role='presentation' class='main'>
        
                    <tr>
                        <td class='wrapper'>
                        <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                            <tr>
                            <td>
                                <h2>Hi $full_name,</h2>
                                <p>$messagereply <br><br>
                                <strong>Ticket Status: $trans_status</strong>

</p>
                                
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unautorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
</td>
</tr>
</table>
</body>

</html>";
    }



    public function AdminWithdrawalMsg($full_name, $amount, $user_balance, $internetid, $trans_status, $trans_type, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        // Format account number
    $last_six = substr($internetid, -6);
    $mask_length = max(0, strlen($internetid) - 6); // Avoid negative length
    $masked = str_repeat("*", $mask_length);
    $formatted_account = $masked . $last_six;
    
        return "<!doctype html>
<html>
    <head>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
        <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
        <title>Transaction Notifications</title>
        <style>
        /* -------------------------------------
            GLOBAL RESETS
        ------------------------------------- */
        
        /*All the styling goes here*/
        
        img {
            border: none;
            -ms-interpolation-mode: bicubic;
            max-width: 100%; 
        }
    
        body {
            background-color: #f6f6f6;
            font-family: sans-serif;
            -webkit-font-smoothing: antialiased;
            font-size: 14px;
            line-height: 1.4;
            margin: 0;
            padding: 0;
            -ms-text-size-adjust: 100%;
            -webkit-text-size-adjust: 100%; 
        }
    
        table {
            border-collapse: separate;
            mso-table-lspace: 0pt;
            mso-table-rspace: 0pt;
            width: 100%; }
            table td {
            font-family: sans-serif;
            font-size: 14px;
            vertical-align: top; 
        }
    
        /* -------------------------------------
            BODY & CONTAINER
        ------------------------------------- */
    
        .body {
            background-color: #f6f6f6;
            width: 100%; 
        }
    
        /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
        .container {
            display: block;
            margin: 0 auto !important;
            /* makes it centered */
            max-width: 580px;
            padding: 10px;
            width: 580px; 
        }
    
        /* This should also be a block element, so that it will fill 100% of the .container */
        .content {
            box-sizing: border-box;
            display: block;
            margin: 0 auto;
            max-width: 580px;
            padding: 10px; 
        }
    
        /* -------------------------------------
            HEADER, FOOTER, MAIN
        ------------------------------------- */
        .main {
            background: #ffffff;
            border-radius: 3px;
            width: 100%; 
        }
    
        .wrapper {
            box-sizing: border-box;
            padding: 20px; 
        }
    
        .content-block {
            padding-bottom: 10px;
            padding-top: 10px;
        }
    
        .footer {
            clear: both;
            margin-top: 10px;
            text-align: center;
            width: 100%; 
        }
            .footer td,
            .footer p,
            .footer span,
            .footer a {
            color: #999999;
            font-size: 12px;
            text-align: center; 
        }
    
        /* -------------------------------------
            TYPOGRAPHY
        ------------------------------------- */
        h1,
        h2,
        h3,
        h4 {
            color: #000000;
            font-family: sans-serif;
            font-weight: 400;
            line-height: 1.4;
            margin: 0;
            margin-bottom: 30px; 
        }
    
        h1 {
            font-size: 35px;
            font-weight: 300;
            text-align: center;
            text-transform: capitalize; 
        }
    
        p,
        ul,
        ol {
            font-family: sans-serif;
            font-size: 14px;
            font-weight: normal;
            margin: 0;
            margin-bottom: 15px; 
        }
            p li,
            ul li,
            ol li {
            list-style-position: inside;
            margin-left: 5px; 
        }
    
        a {
            color: #3498db;
            text-decoration: underline; 
        }
    
        /* -------------------------------------
            BUTTONS
        ------------------------------------- */
        .btn {
            box-sizing: border-box;
            width: 100%; }
            .btn > tbody > tr > td {
            padding-bottom: 15px; }
            .btn table {
            width: auto; 
        }
            .btn table td {
            background-color: #ffffff;
            border-radius: 5px;
            text-align: center; 
        }
            .btn a {
            background-color: #ffffff;
            border: solid 1px #3498db;
            border-radius: 5px;
            box-sizing: border-box;
            color: #3498db;
            cursor: pointer;
            display: inline-block;
            font-size: 14px;
            font-weight: bold;
            margin: 0;
            padding: 12px 25px;
            text-decoration: none;
            text-transform: capitalize; 
        }
    
        .btn-primary table td {
            background-color: #3498db; 
        }
    
        .btn-primary a {
            background-color: #3498db;
            border-color: #3498db;
            color: #ffffff; 
        }
    
        /* -------------------------------------
            OTHER STYLES THAT MIGHT BE USEFUL
        ------------------------------------- */
        .last {
            margin-bottom: 0; 
        }
    
        .first {
            margin-top: 0; 
        }
    
        .align-center {
            text-align: center; 
        }
    
        .align-right {
            text-align: right; 
        }
    
        .align-left {
            text-align: left; 
        }
    
        .clear {
            clear: both; 
        }
    
        .mt0 {
            margin-top: 0; 
        }
    
        .mb0 {
            margin-bottom: 0; 
        }
    
        .preheader {
            color: transparent;
            display: none;
            height: 0;
            max-height: 0;
            max-width: 0;
            opacity: 0;
            overflow: hidden;
            mso-hide: all;
            visibility: hidden;
            width: 0; 
        }
    
        .powered-by a {
            text-decoration: none; 
        }
    
        hr {
            border: 0;
            border-bottom: 1px solid #f6f6f6;
            margin: 20px 0; 
        }
    
        /* -------------------------------------
            RESPONSIVE AND MOBILE FRIENDLY STYLES
        ------------------------------------- */
        @media only screen and (max-width: 620px) {
            table.body h1 {
            font-size: 28px !important;
            margin-bottom: 10px !important; 
            }
            table.body p,
            table.body ul,
            table.body ol,
            table.body td,
            table.body span,
            table.body a {
            font-size: 16px !important; 
            }
            table.body .wrapper,
            table.body .article {
            padding: 10px !important; 
            }
            table.body .content {
            padding: 0 !important; 
            }
            table.body .container {
            padding: 0 !important;
            width: 100% !important; 
            }
            table.body .main {
            border-left-width: 0 !important;
            border-radius: 0 !important;
            border-right-width: 0 !important; 
            }
            table.body .btn table {
            width: 100% !important; 
            }
            table.body .btn a {
            width: 100% !important; 
            }
            table.body .img-responsive {
            height: auto !important;
            max-width: 100% !important;
            width: auto !important; 
            }
        }
    
        /* -------------------------------------
            PRESERVE THESE STYLES IN THE HEAD
        ------------------------------------- */
        @media all {
            .ExternalClass {
            width: 100%; 
            }
            .ExternalClass,
            .ExternalClass p,
            .ExternalClass span,
            .ExternalClass font,
            .ExternalClass td,
            .ExternalClass div {
            line-height: 100%; 
            }
            .apple-link a {
            color: inherit !important;
            font-family: inherit !important;
            font-size: inherit !important;
            font-weight: inherit !important;
            line-height: inherit !important;
            text-decoration: none !important; 
            }
            #MessageViewBody a {
            color: inherit;
            text-decoration: none;
            font-size: inherit;
            font-family: inherit;
            font-weight: inherit;
            line-height: inherit;
            }
            .btn-primary table td:hover {
            background-color: #34495e !important; 
            }
            .btn-primary a:hover {
            background-color: #34495e !important;
            border-color: #34495e !important; 
            } 
        }
    
        </style>
    </head>
<body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>
                        <img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>                                 <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' display: block;   margin: auto;   width: 50%;'>
        <span class='preheader'><u>Transaction Notifications</u></span>
        <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
        <tr>
            <td>&nbsp;</td>
            <td class='container'>
            <div class='content'>
    
                <table role='presentation' class='main'>
    
                <tr>
                    <td class='wrapper'>
                    <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                        <tr>
                        <td>
                        <h2>Hi $full_name,</h2>
                        <p>A $trans_type Transaction of <strong>USD$amount</strong> occurred on account $formatted_account.<br><br>
                        
                        <hr>
                        <strong>Account Balance: USD $user_balance</strong><br>
                        <strong>Transaction Status: $trans_status</strong>
                        <strong>Date: $trans_status</strong>

</p>
                                
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unautorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
</td>
</tr>
</table>
</body>

</html>";
    }

    public function AdminRegisterMsg($full_name, $acct_no, $acct_status, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
        <html>
                <head>
                    <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                    <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                    <title>Hi $full_name, Welcome to $APP_NAME!</title>
                    <style>
                    /* -------------------------------------
                        GLOBAL RESETS
                    ------------------------------------- */
                    
                    /*All the styling goes here*/
                    
                    img {
                        border: none;
                        -ms-interpolation-mode: bicubic;
                        max-width: 100%; 
                    }
                
                    body {
                        background-color: #f6f6f6;
                        font-family: sans-serif;
                        -webkit-font-smoothing: antialiased;
                        font-size: 14px;
                        line-height: 1.4;
                        margin: 0;
                        padding: 0;
                        -ms-text-size-adjust: 100%;
                        -webkit-text-size-adjust: 100%; 
                    }
                
                    table {
                        border-collapse: separate;
                        mso-table-lspace: 0pt;
                        mso-table-rspace: 0pt;
                        width: 100%; }
                        table td {
                        font-family: sans-serif;
                        font-size: 14px;
                        vertical-align: top; 
                    }
                
                    /* -------------------------------------
                        BODY & CONTAINER
                    ------------------------------------- */
                
                    .body {
                        background-color: #f6f6f6;
                        width: 100%; 
                    }
                
                    /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                    .container {
                        display: block;
                        margin: 0 auto !important;
                        /* makes it centered */
                        max-width: 580px;
                        padding: 10px;
                        width: 580px; 
                    }
                
                    /* This should also be a block element, so that it will fill 100% of the .container */
                    .content {
                        box-sizing: border-box;
                        display: block;
                        margin: 0 auto;
                        max-width: 580px;
                        padding: 10px; 
                    }
                
                    /* -------------------------------------
                        HEADER, FOOTER, MAIN
                    ------------------------------------- */
                    .main {
                        background: #ffffff;
                        border-radius: 3px;
                        width: 100%; 
                    }
                
                    .wrapper {
                        box-sizing: border-box;
                        padding: 20px; 
                    }
                
                    .content-block {
                        padding-bottom: 10px;
                        padding-top: 10px;
                    }
                
                    .footer {
                        clear: both;
                        margin-top: 10px;
                        text-align: center;
                        width: 100%; 
                    }
                        .footer td,
                        .footer p,
                        .footer span,
                        .footer a {
                        color: #999999;
                        font-size: 12px;
                        text-align: center; 
                    }
                
                    /* -------------------------------------
                        TYPOGRAPHY
                    ------------------------------------- */
                    h1,
                    h2,
                    h3,
                    h4 {
                        color: #000000;
                        font-family: sans-serif;
                        font-weight: 400;
                        line-height: 1.4;
                        margin: 0;
                        margin-bottom: 30px; 
                    }
                
                    h1 {
                        font-size: 35px;
                        font-weight: 300;
                        text-align: center;
                        text-transform: capitalize; 
                    }
                
                    p,
                    ul,
                    ol {
                        font-family: sans-serif;
                        font-size: 14px;
                        font-weight: normal;
                        margin: 0;
                        margin-bottom: 15px; 
                    }
                        p li,
                        ul li,
                        ol li {
                        list-style-position: inside;
                        margin-left: 5px; 
                    }
                
                    a {
                        color: #3498db;
                        text-decoration: underline; 
                    }
                
                    /* -------------------------------------
                        BUTTONS
                    ------------------------------------- */
                    .btn {
                        box-sizing: border-box;
                        width: 100%; }
                        .btn > tbody > tr > td {
                        padding-bottom: 15px; }
                        .btn table {
                        width: auto; 
                    }
                        .btn table td {
                        background-color: #ffffff;
                        border-radius: 5px;
                        text-align: center; 
                    }
                        .btn a {
                        background-color: #ffffff;
                        border: solid 1px #3498db;
                        border-radius: 5px;
                        box-sizing: border-box;
                        color: #3498db;
                        cursor: pointer;
                        display: inline-block;
                        font-size: 14px;
                        font-weight: bold;
                        margin: 0;
                        padding: 12px 25px;
                        text-decoration: none;
                        text-transform: capitalize; 
                    }
                
                    .btn-primary table td {
                        background-color: #3498db; 
                    }
                
                    .btn-primary a {
                        background-color: #3498db;
                        border-color: #3498db;
                        color: #ffffff; 
                    }
                
                    /* -------------------------------------
                        OTHER STYLES THAT MIGHT BE USEFUL
                    ------------------------------------- */
                    .last {
                        margin-bottom: 0; 
                    }
                
                    .first {
                        margin-top: 0; 
                    }
                
                    .align-center {
                        text-align: center; 
                    }
                
                    .align-right {
                        text-align: right; 
                    }
                
                    .align-left {
                        text-align: left; 
                    }
                
                    .clear {
                        clear: both; 
                    }
                
                    .mt0 {
                        margin-top: 0; 
                    }
                
                    .mb0 {
                        margin-bottom: 0; 
                    }
                
                    .preheader {
                        color: transparent;
                        display: none;
                        height: 0;
                        max-height: 0;
                        max-width: 0;
                        opacity: 0;
                        overflow: hidden;
                        mso-hide: all;
                        visibility: hidden;
                        width: 0; 
                    }
                
                    .powered-by a {
                        text-decoration: none; 
                    }
                
                    hr {
                        border: 0;
                        border-bottom: 1px solid #f6f6f6;
                        margin: 20px 0; 
                    }
                
                    /* -------------------------------------
                        RESPONSIVE AND MOBILE FRIENDLY STYLES
                    ------------------------------------- */
                    @media only screen and (max-width: 620px) {
                        table.body h1 {
                        font-size: 28px !important;
                        margin-bottom: 10px !important; 
                        }
                        table.body p,
                        table.body ul,
                        table.body ol,
                        table.body td,
                        table.body span,
                        table.body a {
                        font-size: 16px !important; 
                        }
                        table.body .wrapper,
                        table.body .article {
                        padding: 10px !important; 
                        }
                        table.body .content {
                        padding: 0 !important; 
                        }
                        table.body .container {
                        padding: 0 !important;
                        width: 100% !important; 
                        }
                        table.body .main {
                        border-left-width: 0 !important;
                        border-radius: 0 !important;
                        border-right-width: 0 !important; 
                        }
                        table.body .btn table {
                        width: 100% !important; 
                        }
                        table.body .btn a {
                        width: 100% !important; 
                        }
                        table.body .img-responsive {
                        height: auto !important;
                        max-width: 100% !important;
                        width: auto !important; 
                        }
                    }
                
                    /* -------------------------------------
                        PRESERVE THESE STYLES IN THE HEAD
                    ------------------------------------- */
                    @media all {
                        .ExternalClass {
                        width: 100%; 
                        }
                        .ExternalClass,
                        .ExternalClass p,
                        .ExternalClass span,
                        .ExternalClass font,
                        .ExternalClass td,
                        .ExternalClass div {
                        line-height: 100%; 
                        }
                        .apple-link a {
                        color: inherit !important;
                        font-family: inherit !important;
                        font-size: inherit !important;
                        font-weight: inherit !important;
                        line-height: inherit !important;
                        text-decoration: none !important; 
                        }
                        #MessageViewBody a {
                        color: inherit;
                        text-decoration: none;
                        font-size: inherit;
                        font-family: inherit;
                        font-weight: inherit;
                        line-height: inherit;
                        }
                        .btn-primary table td:hover {
                        background-color: #34495e !important; 
                        }
                        .btn-primary a:hover {
                        background-color: #34495e !important;
                        border-color: #34495e !important; 
                        } 
                    }
                
                    </style>
                </head>
<body style='background: #fff; border: none; padding: 10px; border-radius: 20px;'>
<div class='header' style='background: #111; padding:0px;'>
                        <img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>   
                        </div>
                        <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' display: block;   margin: auto;   width: 50%;'>
                    <span class='preheader'>Welcome Email Notification</span>
                    <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                    <tr>
                        <td>&nbsp;</td>
                        <td class='container'>
                        <div class='content'>
                
                            <table role='presentation' class='main'>
                
                            <tr>
                                <td class='wrapper'>
                                <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                    <tr>
                                    <td>
                                    <h2>Dear $full_name,</h2>
                                    <p><strong>Welcome to $APP_NAME</strong>
                                    <br><br><br>Thank you for opening an account with us at $APP_NAME.<br>
                                    <strong>$acct_no</strong> We are excited to see you create with us.<br><br>
                                    If you need any assitance, our support team is here to help. Do not hesitate to get in touch.
                                    if you have any questions or concern.<br><br>
                                    Account Status: $acct_status</p>
                                              
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unautorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
        
                        </td>
                    </tr>
                    </table>
                </body>
        </html>";
    }


    public function MessageUsers($subjectid, $messageid, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
        <html>
                <head>
                    <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                    <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                    <title> $subjectid</title>
                    <style>
                    /* -------------------------------------
                        GLOBAL RESETS
                    ------------------------------------- */
                    
                    /*All the styling goes here*/
                    
                    img {
                        border: none;
                        -ms-interpolation-mode: bicubic;
                        max-width: 100%; 
                    }
                
                    body {
                        background-color: #f6f6f6;
                        font-family: sans-serif;
                        -webkit-font-smoothing: antialiased;
                        font-size: 14px;
                        line-height: 1.4;
                        margin: 0;
                        padding: 0;
                        -ms-text-size-adjust: 100%;
                        -webkit-text-size-adjust: 100%; 
                    }
                
                    table {
                        border-collapse: separate;
                        mso-table-lspace: 0pt;
                        mso-table-rspace: 0pt;
                        width: 100%; }
                        table td {
                        font-family: sans-serif;
                        font-size: 14px;
                        vertical-align: top; 
                    }
                
                    /* -------------------------------------
                        BODY & CONTAINER
                    ------------------------------------- */
                
                    .body {
                        background-color: #f6f6f6;
                        width: 100%; 
                    }
                
                    /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                    .container {
                        display: block;
                        margin: 0 auto !important;
                        /* makes it centered */
                        max-width: 580px;
                        padding: 10px;
                        width: 580px; 
                    }
                
                    /* This should also be a block element, so that it will fill 100% of the .container */
                    .content {
                        box-sizing: border-box;
                        display: block;
                        margin: 0 auto;
                        max-width: 580px;
                        padding: 10px; 
                    }
                
                    /* -------------------------------------
                        HEADER, FOOTER, MAIN
                    ------------------------------------- */
                    .main {
                        background: #ffffff;
                        border-radius: 3px;
                        width: 100%; 
                    }
                
                    .wrapper {
                        box-sizing: border-box;
                        padding: 20px; 
                    }
                
                    .content-block {
                        padding-bottom: 10px;
                        padding-top: 10px;
                    }
                
                    .footer {
                        clear: both;
                        margin-top: 10px;
                        text-align: center;
                        width: 100%; 
                    }
                        .footer td,
                        .footer p,
                        .footer span,
                        .footer a {
                        color: #999999;
                        font-size: 12px;
                        text-align: center; 
                    }
                
                    /* -------------------------------------
                        TYPOGRAPHY
                    ------------------------------------- */
                    h1,
                    h2,
                    h3,
                    h4 {
                        color: #000000;
                        font-family: sans-serif;
                        font-weight: 400;
                        line-height: 1.4;
                        margin: 0;
                        margin-bottom: 30px; 
                    }
                
                    h1 {
                        font-size: 35px;
                        font-weight: 300;
                        text-align: center;
                        text-transform: capitalize; 
                    }
                
                    p,
                    ul,
                    ol {
                        font-family: sans-serif;
                        font-size: 14px;
                        font-weight: normal;
                        margin: 0;
                        margin-bottom: 15px; 
                    }
                        p li,
                        ul li,
                        ol li {
                        list-style-position: inside;
                        margin-left: 5px; 
                    }
                
                    a {
                        color: #3498db;
                        text-decoration: underline; 
                    }
                
                    /* -------------------------------------
                        BUTTONS
                    ------------------------------------- */
                    .btn {
                        box-sizing: border-box;
                        width: 100%; }
                        .btn > tbody > tr > td {
                        padding-bottom: 15px; }
                        .btn table {
                        width: auto; 
                    }
                        .btn table td {
                        background-color: #ffffff;
                        border-radius: 5px;
                        text-align: center; 
                    }
                        .btn a {
                        background-color: #ffffff;
                        border: solid 1px #3498db;
                        border-radius: 5px;
                        box-sizing: border-box;
                        color: #3498db;
                        cursor: pointer;
                        display: inline-block;
                        font-size: 14px;
                        font-weight: bold;
                        margin: 0;
                        padding: 12px 25px;
                        text-decoration: none;
                        text-transform: capitalize; 
                    }
                
                    .btn-primary table td {
                        background-color: #3498db; 
                    }
                
                    .btn-primary a {
                        background-color: #3498db;
                        border-color: #3498db;
                        color: #ffffff; 
                    }
                
                    /* -------------------------------------
                        OTHER STYLES THAT MIGHT BE USEFUL
                    ------------------------------------- */
                    .last {
                        margin-bottom: 0; 
                    }
                
                    .first {
                        margin-top: 0; 
                    }
                
                    .align-center {
                        text-align: center; 
                    }
                
                    .align-right {
                        text-align: right; 
                    }
                
                    .align-left {
                        text-align: left; 
                    }
                
                    .clear {
                        clear: both; 
                    }
                
                    .mt0 {
                        margin-top: 0; 
                    }
                
                    .mb0 {
                        margin-bottom: 0; 
                    }
                
                    .preheader {
                        color: transparent;
                        display: none;
                        height: 0;
                        max-height: 0;
                        max-width: 0;
                        opacity: 0;
                        overflow: hidden;
                        mso-hide: all;
                        visibility: hidden;
                        width: 0; 
                    }
                
                    .powered-by a {
                        text-decoration: none; 
                    }
                
                    hr {
                        border: 0;
                        border-bottom: 1px solid #f6f6f6;
                        margin: 20px 0; 
                    }
                
                    /* -------------------------------------
                        RESPONSIVE AND MOBILE FRIENDLY STYLES
                    ------------------------------------- */
                    @media only screen and (max-width: 620px) {
                        table.body h1 {
                        font-size: 28px !important;
                        margin-bottom: 10px !important; 
                        }
                        table.body p,
                        table.body ul,
                        table.body ol,
                        table.body td,
                        table.body span,
                        table.body a {
                        font-size: 16px !important; 
                        }
                        table.body .wrapper,
                        table.body .article {
                        padding: 10px !important; 
                        }
                        table.body .content {
                        padding: 0 !important; 
                        }
                        table.body .container {
                        padding: 0 !important;
                        width: 100% !important; 
                        }
                        table.body .main {
                        border-left-width: 0 !important;
                        border-radius: 0 !important;
                        border-right-width: 0 !important; 
                        }
                        table.body .btn table {
                        width: 100% !important; 
                        }
                        table.body .btn a {
                        width: 100% !important; 
                        }
                        table.body .img-responsive {
                        height: auto !important;
                        max-width: 100% !important;
                        width: auto !important; 
                        }
                    }
                
                    /* -------------------------------------
                        PRESERVE THESE STYLES IN THE HEAD
                    ------------------------------------- */
                    @media all {
                        .ExternalClass {
                        width: 100%; 
                        }
                        .ExternalClass,
                        .ExternalClass p,
                        .ExternalClass span,
                        .ExternalClass font,
                        .ExternalClass td,
                        .ExternalClass div {
                        line-height: 100%; 
                        }
                        .apple-link a {
                        color: inherit !important;
                        font-family: inherit !important;
                        font-size: inherit !important;
                        font-weight: inherit !important;
                        line-height: inherit !important;
                        text-decoration: none !important; 
                        }
                        #MessageViewBody a {
                        color: inherit;
                        text-decoration: none;
                        font-size: inherit;
                        font-family: inherit;
                        font-weight: inherit;
                        line-height: inherit;
                        }
                        .btn-primary table td:hover {
                        background-color: #34495e !important; 
                        }
                        .btn-primary a:hover {
                        background-color: #34495e !important;
                        border-color: #34495e !important; 
                        } 
                    }
                
                    </style>
                </head>
<body style='background: #fff; border: none #111; padding: 10px; border-radius: 20px;'>
                        <img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>                                 
                        <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' display: block;   margin: auto;   width: 50%;'>
                    <span class='preheader'>Welcome Email Notification</span>
                    <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                    <tr>
                        <td>&nbsp;</td>
                        <td class='container'>
                        <div class='content'>
                
                            <table role='presentation' class='main'>
                
                            <tr>
                                <td class='wrapper'>
                                <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                    <tr>
                                    <td>
                                    <h2>$subjectid,</h2>
                                    <p>$messageid</p>
                                                       
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unautorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
        
                        </td>
                    </tr>
                    </table>
                </body>
        </html>";
    }

    public function AdminWireMsg($full_name,$internetid, $amount, $user_balance, $trans_status, $trans_type, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        // Format account number
    $last_six = substr($internetid, -6);
    $mask_length = max(0, strlen($internetid) - 6); // Avoid negative length
    $masked = str_repeat("*", $mask_length);
    $formatted_account = $masked . $last_six;

    // Format amounts
    
    $user_balance_sum =$user_balance + $amount;
    $formatted_amount = number_format($amount, 2);
    $formatted_balance = number_format($user_balance_sum, 2);
    
        return "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8' />
  <meta name='viewport' content='width=device-width, initial-scale=1.0' />
  <title>Wire Transfer Transaction Notification – $APP_NAME</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    table {
      width: 100%;
      border-spacing: 0;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .transaction-box {
      background-color: #1a1a1a;
      color: #ffffff;
      padding: 20px;
      border-radius: 6px;
      margin-top: 20px;
      font-size: 15px;
      line-height: 1.8;
    }
    .transaction-box strong {
      color: #ffffff;
    }
    a {
      color: #B22222;
      text-decoration: none;
    }
    ul {
      list-style-type: none;
      padding: 0;
    }
    li {
      margin-bottom: 10px;
    }
    @media (max-width: 600px) {
      .email-container {
        width: 100%;
        padding: 15px;
      }
      .transaction-box {
        padding: 15px;
      }
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>

          <!-- Header Section -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>$APP_NAME</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body Section -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear <strong>$full_name</strong>,</p>
            <p>We wish to inform you that a $trans_type has been successfully processed on your account. Below are the transaction details:</p>

            <div class='transaction-box'>
              <p><strong>Account Number:</strong> $formatted_account</p>
              <p><strong>Account Name:</strong> $full_name</p>
              <p><strong>Amount:</strong> USD$formatted_amount</p>
              <p><strong>Transaction Type:</strong> $trans_type</p>
              <p><strong>Current Balance:</strong> USD$formatted_balance</p>
              <p><strong>Transaction Status:</strong> $trans_status</p>
            </div>

            <p>To view your full account statement or manage your account, log in at: <a href='https://crestwoodpb.pro/login'>https://crestwoodpb.com</a></p>

            <p>If you did not authorize this transaction, please contact us immediately at our Customer Support:</p>

            <ul>
              <li><strong>Support:</strong> <a href='mailto:support@crestwoodpb.com'>support@crestwoodpb.com</a></li>
              <li><strong>Security:</strong> <a href='mailto:security@crestwoodpb.com'>security@crestwoodpb.com</a></li>
              <li><strong>General Inquiries:</strong> <a href='mailto:info@crestwoodpb.com'>info@crestwoodpb.com</a></li>
              <li><strong>Phone:</strong> +1 (329) 223-2062, +1 (332) 291-2566</li>
            </ul>
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>$APP_NAME</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='#'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2025 $APP_NAME. All rights reserved.</p>
          </div>

        </div>
      </td>
    </tr>
  </table>
</body>
</html>";
    }

    public function AdminDomMsg($full_name, $amount, $user_balance, $trans_status, $trans_type, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!DOCTYPE html>
<html lang='en'>
<head>
  <meta charset='UTF-8'>
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <title>$trans_type Transaction Notification – $APP_NAME</title>
  <style>
    body {
      font-family: 'Segoe UI', Roboto, Georgia, serif;
      margin: 0;
      padding: 0;
      background-color: #f4f4f4;
      color: #333;
    }
    table {
      width: 100%;
      border-spacing: 0;
    }
    .email-container {
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    .transaction-box {
      background-color: #1a1a1a;
      color: #ffffff;
      padding: 20px;
      border-radius: 6px;
      margin-top: 20px;
      font-size: 15px;
      line-height: 1.8;
    }
    .transaction-box strong {
      color: #ffffff;
    }
    a {
      color: #B22222;
      text-decoration: none;
    }
    ul {
      list-style-type: none;
      padding: 0;
    }
    li {
      margin-bottom: 10px;
    }
    @media (max-width: 600px) {
      .email-container {
        width: 100%;
        padding: 15px;
      }
      .transaction-box {
        padding: 15px;
      }
    }
  </style>
</head>
<body>
  <table>
    <tr>
      <td>
        <div class='email-container'>

          <!-- Header Section -->
          <div style='background: linear-gradient(to right, #6A4E3A, #B22222); text-align: center; padding: 30px 0;'>
            <p style='font-size: 36px; color: white; font-family: 'Segoe UI', sans-serif; margin: 0; font-weight: bold;'>$APP_NAME</p>
            <p style='font-size: 18px; color: white; font-family: 'Segoe UI', sans-serif; margin: 10px 0;'>Discreet Wealth Management | Offshore Banking | Trusted Advisory</p>
            <div style='width: 50px; height: 3px; background-color: white; margin: 10px auto;'></div>
          </div>

          <!-- Email Body Section -->
          <div style='padding: 20px; font-size: 16px; line-height: 1.6;'>
            <p>Dear $full_name,</p>

            <p>Your $trans_type Transaction of <strong>USD$amount</strong> is $trans_status.<br><br>
                               

          

            <p>No further action is required on your part. For any inquiries, please contact our Customer support:</p>

            <ul>
              <li><strong>Support:</strong> <a href='mailto:support@crestwoodpb.com' style='color: #B22222; text-decoration: none;'>support@crestwoodpb.com</a></li>
              <li><strong>Security:</strong> <a href='mailto:security@crestwoodpb.com' style='color: #B22222; text-decoration: none;'>security@crestwoodpb.com</a></li>
              <li><strong>General Inquiries:</strong> <a href='mailto:info@crestwoodpb.com' style='color: #B22222; text-decoration: none;'>info@crestwoodpb.com</a></li>
              <li><strong>Phone:</strong> +1 (329) 223-2062, +1 (332) 291-2566</li>
            </ul>
          </div>

          <!-- Footer Section -->
          <div style='background-color: #f9f9f9; text-align: center; padding: 25px 0; font-size: 12px; color: #888;'>
            <p style='margin: 10px 0;'>This email and any attachments are confidential and may contain privileged information. If you are not the intended recipient, please delete this message immediately and notify the sender. Unauthorized use, disclosure, or distribution is strictly prohibited.</p>
            <p style='margin: 10px 0;'>We will never ask for your login credentials or personal details via email or phone. If you receive such requests, please report them to our security team.</p>
            <p style='margin: 10px 0;'><strong>$APP_NAME</strong><br>1441 Broadway, New York, NY 10018</p>
            <p style='margin: 10px 0;'><a href='[Unsubscribe Link]' style='color: #B22222; text-decoration: none;'>Click here to unsubscribe</a></p>
            <p style='margin: 10px 0;'>&copy; 2025 $APP_NAMEk. All rights reserved.</p>
          </div>

        </div>
      </td>
    </tr>
  </table>
</body>
</html>";
    }

    public function AdminInterMsg($full_name, $amount, $user_balance, $trans_status, $trans_type, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Interbank Notifications</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #f6f6f6;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #f6f6f6;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #999999;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #f6f6f6;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
<body style='background: #fff; border: none #111; padding: 10px; border-radius: 20px;'>
                        <img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>                                 <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' display: block;   margin: auto;   width: 50%;'>
                <span class='preheader'><u>Interbank Notifications</u></span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
                                <h2>Hi $full_name,</h2>
                                <p>Your $trans_type Transaction of <strong>USD$amount</strong> is $trans_status.<br><br>
                                <strong>Account Balance: USD$user_balance</strong></p>
                                
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unautorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }

    public function AdminStockMsg($full_name, $amount, $user_balance, $trans_status, $trans_type, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Stock Interest Notifications</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #f6f6f6;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #f6f6f6;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #999999;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #f6f6f6;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
<body style='background: #fff; border: none #111; padding: 10px; border-radius: 20px;'>
                        <img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>                                 <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' display: block;   margin: auto;   width: 50%;'>
                <span class='preheader'>Stock Interest Notifications</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
                                <h2>Hi $full_name,</h2>
                                <p>$trans_type with the interest of <strong>USD$amount</strong> is $trans_status.<br><br>
                                <strong>Account Balance: $user_balance</strong></p>
                                                          
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unautorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }

    public function AdminLoanMsg($full_name, $amount, $loan_balance, $internetid, $trans_status, $APP_NAME, $APP_URL, $SITE_ADDRESS)
    {
        // Format account number
    $last_six = substr($internetid, -6);
    $mask_length = max(0, strlen($internetid) - 6); // Avoid negative length
    $masked = str_repeat("*", $mask_length);
    $formatted_account = $masked . $last_six;
    
        return "<!doctype html>
    <html>
            <head>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'/>
                <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
                <title>Loan Application</title>
                <style>
                /* -------------------------------------
                    GLOBAL RESETS
                ------------------------------------- */
                
                /*All the styling goes here*/
                
                img {
                    border: none;
                    -ms-interpolation-mode: bicubic;
                    max-width: 100%; 
                }
            
                body {
                    background-color: #f6f6f6;
                    font-family: sans-serif;
                    -webkit-font-smoothing: antialiased;
                    font-size: 14px;
                    line-height: 1.4;
                    margin: 0;
                    padding: 0;
                    -ms-text-size-adjust: 100%;
                    -webkit-text-size-adjust: 100%; 
                }
            
                table {
                    border-collapse: separate;
                    mso-table-lspace: 0pt;
                    mso-table-rspace: 0pt;
                    width: 100%; }
                    table td {
                    font-family: sans-serif;
                    font-size: 14px;
                    vertical-align: top; 
                }
            
                /* -------------------------------------
                    BODY & CONTAINER
                ------------------------------------- */
            
                .body {
                    background-color: #f6f6f6;
                    width: 100%; 
                }
            
                /* Set a max-width, and make it display as block so it will automatically stretch to that width, but will also shrink down on a phone or something */
                .container {
                    display: block;
                    margin: 0 auto !important;
                    /* makes it centered */
                    max-width: 580px;
                    padding: 10px;
                    width: 580px; 
                }
            
                /* This should also be a block element, so that it will fill 100% of the .container */
                .content {
                    box-sizing: border-box;
                    display: block;
                    margin: 0 auto;
                    max-width: 580px;
                    padding: 10px; 
                }
            
                /* -------------------------------------
                    HEADER, FOOTER, MAIN
                ------------------------------------- */
                .main {
                    background: #ffffff;
                    border-radius: 3px;
                    width: 100%; 
                }
            
                .wrapper {
                    box-sizing: border-box;
                    padding: 20px; 
                }
            
                .content-block {
                    padding-bottom: 10px;
                    padding-top: 10px;
                }
            
                .footer {
                    clear: both;
                    margin-top: 10px;
                    text-align: center;
                    width: 100%; 
                }
                    .footer td,
                    .footer p,
                    .footer span,
                    .footer a {
                    color: #999999;
                    font-size: 12px;
                    text-align: center; 
                }
            
                /* -------------------------------------
                    TYPOGRAPHY
                ------------------------------------- */
                h1,
                h2,
                h3,
                h4 {
                    color: #000000;
                    font-family: sans-serif;
                    font-weight: 400;
                    line-height: 1.4;
                    margin: 0;
                    margin-bottom: 30px; 
                }
            
                h1 {
                    font-size: 35px;
                    font-weight: 300;
                    text-align: center;
                    text-transform: capitalize; 
                }
            
                p,
                ul,
                ol {
                    font-family: sans-serif;
                    font-size: 14px;
                    font-weight: normal;
                    margin: 0;
                    margin-bottom: 15px; 
                }
                    p li,
                    ul li,
                    ol li {
                    list-style-position: inside;
                    margin-left: 5px; 
                }
            
                a {
                    color: #3498db;
                    text-decoration: underline; 
                }
            
                /* -------------------------------------
                    BUTTONS
                ------------------------------------- */
                .btn {
                    box-sizing: border-box;
                    width: 100%; }
                    .btn > tbody > tr > td {
                    padding-bottom: 15px; }
                    .btn table {
                    width: auto; 
                }
                    .btn table td {
                    background-color: #ffffff;
                    border-radius: 5px;
                    text-align: center; 
                }
                    .btn a {
                    background-color: #ffffff;
                    border: solid 1px #3498db;
                    border-radius: 5px;
                    box-sizing: border-box;
                    color: #3498db;
                    cursor: pointer;
                    display: inline-block;
                    font-size: 14px;
                    font-weight: bold;
                    margin: 0;
                    padding: 12px 25px;
                    text-decoration: none;
                    text-transform: capitalize; 
                }
            
                .btn-primary table td {
                    background-color: #3498db; 
                }
            
                .btn-primary a {
                    background-color: #3498db;
                    border-color: #3498db;
                    color: #ffffff; 
                }
            
                /* -------------------------------------
                    OTHER STYLES THAT MIGHT BE USEFUL
                ------------------------------------- */
                .last {
                    margin-bottom: 0; 
                }
            
                .first {
                    margin-top: 0; 
                }
            
                .align-center {
                    text-align: center; 
                }
            
                .align-right {
                    text-align: right; 
                }
            
                .align-left {
                    text-align: left; 
                }
            
                .clear {
                    clear: both; 
                }
            
                .mt0 {
                    margin-top: 0; 
                }
            
                .mb0 {
                    margin-bottom: 0; 
                }
            
                .preheader {
                    color: transparent;
                    display: none;
                    height: 0;
                    max-height: 0;
                    max-width: 0;
                    opacity: 0;
                    overflow: hidden;
                    mso-hide: all;
                    visibility: hidden;
                    width: 0; 
                }
            
                .powered-by a {
                    text-decoration: none; 
                }
            
                hr {
                    border: 0;
                    border-bottom: 1px solid #f6f6f6;
                    margin: 20px 0; 
                }
            
                /* -------------------------------------
                    RESPONSIVE AND MOBILE FRIENDLY STYLES
                ------------------------------------- */
                @media only screen and (max-width: 620px) {
                    table.body h1 {
                    font-size: 28px !important;
                    margin-bottom: 10px !important; 
                    }
                    table.body p,
                    table.body ul,
                    table.body ol,
                    table.body td,
                    table.body span,
                    table.body a {
                    font-size: 16px !important; 
                    }
                    table.body .wrapper,
                    table.body .article {
                    padding: 10px !important; 
                    }
                    table.body .content {
                    padding: 0 !important; 
                    }
                    table.body .container {
                    padding: 0 !important;
                    width: 100% !important; 
                    }
                    table.body .main {
                    border-left-width: 0 !important;
                    border-radius: 0 !important;
                    border-right-width: 0 !important; 
                    }
                    table.body .btn table {
                    width: 100% !important; 
                    }
                    table.body .btn a {
                    width: 100% !important; 
                    }
                    table.body .img-responsive {
                    height: auto !important;
                    max-width: 100% !important;
                    width: auto !important; 
                    }
                }
            
                /* -------------------------------------
                    PRESERVE THESE STYLES IN THE HEAD
                ------------------------------------- */
                @media all {
                    .ExternalClass {
                    width: 100%; 
                    }
                    .ExternalClass,
                    .ExternalClass p,
                    .ExternalClass span,
                    .ExternalClass font,
                    .ExternalClass td,
                    .ExternalClass div {
                    line-height: 100%; 
                    }
                    .apple-link a {
                    color: inherit !important;
                    font-family: inherit !important;
                    font-size: inherit !important;
                    font-weight: inherit !important;
                    line-height: inherit !important;
                    text-decoration: none !important; 
                    }
                    #MessageViewBody a {
                    color: inherit;
                    text-decoration: none;
                    font-size: inherit;
                    font-family: inherit;
                    font-weight: inherit;
                    line-height: inherit;
                    }
                    .btn-primary table td:hover {
                    background-color: #34495e !important; 
                    }
                    .btn-primary a:hover {
                    background-color: #34495e !important;
                    border-color: #34495e !important; 
                    } 
                }
            
                </style>
            </head>
<body style='background: #fff; border: none #111; padding: 10px; border-radius: 20px;'>
                        <img src='https://crestwoodpb.pro/assets/images/logo/logo2.png' style='background: #111; display: block;   margin: auto;   width: 50%;'>                                 <img src='https://crestwoodpb.pro/assets/images/logo/hero.png' display: block;   margin: auto;   width: 50%;'>
                <span class='preheader'>Loan Application Notification</span>
                <table role='presentation' border='0' cellpadding='0' cellspacing='0' class='body'>
                <tr>
                    <td>&nbsp;</td>
                    <td class='container'>
                    <div class='content'>
            
                        <table role='presentation' class='main'>
            
                        <tr>
                            <td class='wrapper'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                                <tr>
                                <td>
                                <h2>Hi $full_name,</h2>
                                <p>A Loan amount of <strong>USD$amount</strong> on $formatted_account account is $trans_status.<br><br>
                                <strong>Loan Balance: $loan_balance</strong></p>
                                               
                                <p><strong><u>For any concerns or assistance, please contact us:</u></strong><p>
                                <p><b>General Concerns:</b><br>
                                Support@crestwoodpb.com</p>
                                <p><b>Security Concerns:</b><br>
                                Security@crestwoodpb.com</p><br>
                                <p><b>Phone:</b><br>
                                +1 (329) 223-2062, +1 (332) 291-2566
                                </p><br>
                               
                                

                                <p>Your account security is our top priority.</p><br>
                               
                               <p><strong><u>Confidentiality Notice:</u></strong><p> 
                               <i>This email and any attachments are confidential and may contain privileged information. If you are not the intended receipient, please
                               delete this message immediately and notify the sender.<br>
                               Unautorized use, disclosure or distribution are strictly prohibited.<br>
                               We will never ask for your login credentials or personal details via email or phone. Message our support if you get emails asking for your login details.
                               </i><br>
                                <i>This is a system-generated email. Please do not reply directly.
If you no longer wish to receive these emails, you may <a href='#'>Unsubscribe</a>.</i>

                                            </td>
                                            </tr>
                                        </table>
                                        </td>
                                    </tr>
                        
                                    </table>
                                </div>

                                              <div class='footer' style='background: #732e4a; color:#fff; padding:10px;'>
                            <table role='presentation' border='0' cellpadding='0' cellspacing='0'>
                          <td>
                          <tr>
                                     <span class='apple-link'>$APP_NAME, https://crestwoodpb.com</span>
                                     <p>Address: 1441 Broadway, New York, NY 10018.</p>
                                     <br> Don't like these emails? <a href='#'>Click here to Unsubscribe</a>.
                                     <br>Copyright 2025 - <a href='https://crestwoodpb.com'>$APP_NAME</a>.
                            </td>
                        </tr>
                     
                            </table>
                        </div>
    
                    </td>
                </tr>
                </table>
            </body>
    </html>";
    }
}
